///////////////////////////////////////////////////////////////////////////////////////
//
// MonoScan
//
// 27/04/07		Hounddog	Initial implementation
//

namespace MonoScan.MonoMotronic121
{
	using System;
	using System.Xml;
	using System.Windows.Forms;

	public class Scanner : MonoScan.Scanner
	{
		public Scanner(MainForm mainForm, XmlNode xmlNode) : base(mainForm, xmlNode)
		{
			monoMotronicMenuItem = new MenuItem();
			monoMotronicMenuItem.Text = "&Mono Motronic";
			monoMotronicMenuItem.Popup += new System.EventHandler(this.monoMotronicMenuItem_Popup);

			monoMotronicReadDescriptionsMenuItem = new MenuItem();
			monoMotronicReadDescriptionsMenuItem.Text = "Read &Descriptions";
			monoMotronicReadDescriptionsMenuItem.Click += new System.EventHandler(this.monoMotronicReadDescriptionsMenuItem_Click);

			MenuItem separator0MenuItem = new MenuItem();
			separator0MenuItem.Text = "-";

			monoMotronicReadFaultsMenuItem = new MenuItem();
			monoMotronicReadFaultsMenuItem.Text = "Read &Faults";
			monoMotronicReadFaultsMenuItem.Click += new System.EventHandler(this.monoMotronicReadFaultsMenuItem_Click);

			monoMotronicClearFaultsMenuItem = new MenuItem();
			monoMotronicClearFaultsMenuItem.Text = "&Clear Faults";
			monoMotronicClearFaultsMenuItem.Click += new System.EventHandler(this.monoMotronicClearFaultsMenuItem_Click);

			MenuItem separator1MenuItem = new MenuItem();
			separator1MenuItem.Text = "-";

			monoMotronicBasicSettingsMenuItem = new MenuItem();
			monoMotronicBasicSettingsMenuItem.Text = "&Basic Settings";
			monoMotronicBasicSettingsMenuItem.Click += new System.EventHandler(this.monoMotronicBasicSettingsMenuItem_Click);

			MenuItem separator2MenuItem = new MenuItem();
			separator2MenuItem.Text = "-";

			monoMotronicTestActuatorsMenuItem = new MenuItem();
			monoMotronicTestActuatorsMenuItem.Text = "&Test Actuators...";
			monoMotronicTestActuatorsMenuItem.Click += new System.EventHandler(this.monoMotronicTestActuatorsMenuItem_Click);

			MenuItem[] menuItems = new MenuItem[] 
			{ 
				monoMotronicReadDescriptionsMenuItem,
				separator0MenuItem,
				monoMotronicReadFaultsMenuItem,
				monoMotronicClearFaultsMenuItem,
				separator1MenuItem,
				monoMotronicBasicSettingsMenuItem,
				separator2MenuItem,
				monoMotronicTestActuatorsMenuItem
			};

			monoMotronicMenuItem.MenuItems.AddRange(menuItems);

			mainForm.MainMenu.MenuItems.Add(1, monoMotronicMenuItem);

			basicSettings = false;
			actuatorsTest = false;
		}

		protected override void Dispose(bool disposing) 
		{
			try
			{
				if (disposing)
				{
					if (actuatorsTest)
					{
						MessageBox.Show(mainForm, "Switch the ignition off after disconnection for\n" +
							"about 20 sec to cancel the actuators test.", "MonoScan", 
							MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					}

					Form[] forms = mainForm.MdiChildren;

					for (int index = forms.Length - 1; index >= 0; -- index)
						forms[index].Close();

					mainForm.MainMenu.MenuItems.Remove(monoMotronicMenuItem);
				}
			}
			finally
			{
				base.Dispose(disposing);
			}
		}

		protected MenuItem monoMotronicMenuItem;
		protected MenuItem monoMotronicReadDescriptionsMenuItem;
		protected MenuItem monoMotronicReadFaultsMenuItem;
		protected MenuItem monoMotronicClearFaultsMenuItem;
		protected MenuItem monoMotronicBasicSettingsMenuItem;
		protected MenuItem monoMotronicTestActuatorsMenuItem;

		void monoMotronicMenuItem_Popup(object sender, System.EventArgs e)
		{
			monoMotronicReadDescriptionsMenuItem.Enabled = ! actuatorsTest && ! basicSettings;
			monoMotronicReadFaultsMenuItem.Enabled = ! actuatorsTest && ! basicSettings;
			monoMotronicClearFaultsMenuItem.Enabled = ! actuatorsTest && ! basicSettings;
			monoMotronicBasicSettingsMenuItem.Enabled = ! actuatorsTest && ! basicSettings;
			monoMotronicTestActuatorsMenuItem.Enabled = ! basicSettings;
		}

		int statusMessageId;

		void monoMotronicReadDescriptionsMenuItem_Click(object sender, System.EventArgs e)
		{
			try
			{
				XmlNode descriptionsXmlNode = Configuration.FindXmlNode(xmlNode, "Descriptions");
				DescriptionsForm descriptionsForm = new DescriptionsForm(this, descriptionsXmlNode);

				descriptionsForm.Execute();

				descriptionsForm.MdiParent = mainForm;
				descriptionsForm.Show();
			}
			catch (MonoComm.Exception exception)
			{
				mainForm.HandleMonoCommException("Couldn't read ECU descriptions", exception);
			}
			catch (Exception exception)
			{
				mainForm.HandleException("Couldn't read ECU descriptions", exception);
			}
		}

		void monoMotronicReadFaultsMenuItem_Click(object sender, System.EventArgs e)
		{
			try
			{
				XmlNode faultsXmlNode = Configuration.FindXmlNode(xmlNode, "Faults");
				FaultsForm faultsForm = new FaultsForm(this, faultsXmlNode);

				faultsForm.Execute();

				faultsForm.MdiParent = mainForm;
				faultsForm.Show();
			}
			catch (MonoComm.Exception exception)
			{
				mainForm.HandleMonoCommException("Couldn't read ECU faults", exception);
			}
			catch (Exception exception)
			{
				mainForm.HandleException("Couldn't read ECU faults", exception);
			}
		}

		void monoMotronicClearFaultsMenuItem_Click(object sender, System.EventArgs e)
		{
			try
			{
				int statusMessageId = mainForm.PushStatusMessage("Clearing faults");

				try
				{
					mainForm.Update();
				
					MonoComm.Status status = MonoComm.ClearFaults();

					if (status != MonoComm.Status.Ok)
						throw new MonoComm.Exception(status);
				}
				finally
				{
					mainForm.PopStatusMessage(statusMessageId);
				}
			}
			catch (MonoComm.Exception exception)
			{
				mainForm.HandleMonoCommException("Couldn't clear ECU faults", exception);
			}
			catch (Exception exception)
			{
				mainForm.HandleException("Couldn't clear ECU faults", exception);
			}
		}

		void monoMotronicBasicSettingsMenuItem_Click(object sender, System.EventArgs e)
		{
			try
			{
				XmlNode basicSettingsXmlNode = Configuration.FindXmlNode(xmlNode, "BasicSettings");
				BasicSettingsForm basicSettingsForm = new BasicSettingsForm(this, basicSettingsXmlNode);

				basicSettingsForm.Start();

				basicSettingsForm.Closed += new EventHandler(this.basicSettingsForm_Closed);

				basicSettingsForm.MdiParent = mainForm;
				basicSettingsForm.Show();

				basicSettings = true;
			}
			catch (MonoComm.Exception exception)
			{
				mainForm.HandleMonoCommException("Couldn't enter basic settings", exception);
			}
			catch (Exception exception)
			{
				mainForm.HandleException("Couldn't enter basic settings", exception);
			}
		}

		void basicSettingsForm_Closed(object sender, System.EventArgs e)
		{
			basicSettings = false;
		}

		bool basicSettings;

		void monoMotronicTestActuatorsMenuItem_Click(object sender, System.EventArgs e)
		{
			try
			{
				if (! actuatorsTest)
				{
					DialogResult dialogResult = MessageBox.Show(mainForm, "Make sure the engine " +
						"is NOT idling.\n\nUse Next Actuator to move to the next actuator.",
						"MonoScan", MessageBoxButtons.OKCancel, MessageBoxIcon.Information);

					if (dialogResult == DialogResult.Cancel)
						return;

					mainForm.Update();

					monoMotronicTestActuatorsMenuItem.Text = "Next Actuator";					
					actuatorsTest = true;
				}
				else
					mainForm.PopStatusMessage(statusMessageId);

				ushort actuatorCode;
				MonoComm.Status status = MonoComm.TestActuator(out actuatorCode);

				if (status != MonoComm.Status.Ok)
					throw new MonoComm.Exception(status);

				if (actuatorCode != 0)
				{
					XmlNode actuatorXmlNode = Configuration.FindXmlNode(xmlNode, "Actuators/Actuator[@Code=\"{0}\"]", actuatorCode);

					if (actuatorXmlNode != null)
					{
						string actuatorDescription = Configuration.GetXmlNodeAttribute(actuatorXmlNode, "Description");
						statusMessageId = mainForm.PushStatusMessage(actuatorDescription);
					}
					else
						statusMessageId = mainForm.PushStatusMessage("Actuator " + actuatorCode.ToString());
				}
				else
				{
					monoMotronicTestActuatorsMenuItem.Text = "Test Actuators...";
					mainForm.PopStatusMessage(statusMessageId);
					actuatorsTest = false;

					MessageBox.Show(mainForm, "Actuators test completed", "MonoScan",
						MessageBoxButtons.OK, MessageBoxIcon.Information);
				}
			}
			catch (MonoComm.Exception exception)
			{
				mainForm.HandleMonoCommException("Couldn't start actuator", exception);
			}
			catch (Exception exception)
			{
				mainForm.HandleException("Couldn't start actuator", exception);
			}
		}	

		bool actuatorsTest;
	}
}
